/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.pa.util;

import com.ibm.hwmca.fw.pa.problem.Problem;
import com.ibm.hwmca.fw.pa.problem.ProblemManager;
import com.ibm.hwmca.fw.pa.system.PASystem;
import com.ibm.hwmca.fw.util.ByteArray;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.pa.problem.CommonProblem;
import com.ibm.hwmca.xfw.pa.util.PADump;
import com.ibm.hwmca.xfw.pa.util.ProblemDataDescriptor;
import java.io.File;
import java.io.FileInputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class DumpInfo {
    private static final String TRACE_MASKT = "XPADUMPT";
    private static final String TRACE_MASKF = "XPADUMPF";
    private static final String TRACE_MASKD = "XPADUMPD";
    private static boolean skipPm = false;
    private static List testProblemList = new ArrayList();

    private DumpInfo() {
    }

    public static PADump getDumpData() {
        Trace.trace(TRACE_MASKF, "--> getDumpData");
        try {
            ArrayList<PADump> paDumpList;
            block18: {
                paDumpList = new ArrayList<PADump>();
                int numberOfDumpsFound = 0;
                File dumpDir = new File("/dump");
                if (dumpDir != null) {
                    File[] dirList = dumpDir.listFiles();
                    Trace.trace(TRACE_MASKD, "dump out the files");
                    int i = 0;
                    while (i < dirList.length) {
                        Trace.trace(TRACE_MASKD, "name is" + dirList[i].getName());
                        Trace.trace(TRACE_MASKD, "length is" + dirList[i].length());
                        ++i;
                    }
                    if (dirList != null) {
                        int numOfAvailableDumps = dirList.length;
                        Trace.trace(TRACE_MASKD, "got " + numOfAvailableDumps + " dumps to find");
                        ArrayList<String> nameList = new ArrayList<String>(dirList.length);
                        int i2 = 0;
                        while (i2 < dirList.length) {
                            nameList.add(dirList[i2].getName());
                            ++i2;
                        }
                        try {
                            ProblemManager pm = null;
                            if (!skipPm) {
                                pm = ProblemManager.getProblemManager();
                            }
                            if (skipPm || pm != null) {
                                List problemList = skipPm ? testProblemList : pm.getAllProblems();
                                if (problemList != null) {
                                    Trace.trace(TRACE_MASKD, "got " + problemList.size() + " problems to look through");
                                    Iterator it = problemList.iterator();
                                    while (it.hasNext()) {
                                        List dataSet;
                                        Problem currentProblem = (Problem)it.next();
                                        if (currentProblem instanceof CommonProblem && (dataSet = ((CommonProblem)currentProblem).getProblemDataSet()) != null) {
                                            Trace.trace(TRACE_MASKD, "got the data sets");
                                            Iterator pdsIt = dataSet.iterator();
                                            while (pdsIt.hasNext()) {
                                                Trace.trace(TRACE_MASKD, "got some data sets to look through");
                                                ProblemDataDescriptor pdd = (ProblemDataDescriptor)pdsIt.next();
                                                Trace.trace(TRACE_MASKD, "looking for :" + pdd.getName());
                                                Trace.trace(TRACE_MASKD, "type is: " + pdd.getType());
                                                if (!pdd.getType().equals("FSPDUMP") && !pdd.getType().equals("LOGSYSDUMP") && !pdd.getType().equals("PWRDUMP") && !pdd.getType().equals("SMADUMP") && !pdd.getType().equals("SYSDUMP")) continue;
                                                String fileName = pdd.getName();
                                                Trace.trace(TRACE_MASKD, "got a fsp dump to handle");
                                                Trace.trace(TRACE_MASKD, "the name is " + fileName);
                                                int arrayIndex = nameList.indexOf(fileName);
                                                if (arrayIndex > -1) {
                                                    Trace.trace(TRACE_MASKD, "found the file in the dump direct at index " + arrayIndex);
                                                    File theDumpFile = new File("/dump/" + (String)nameList.get(arrayIndex));
                                                    Trace.trace(TRACE_MASKD, "keo " + theDumpFile.getAbsolutePath());
                                                    Trace.trace(TRACE_MASKD, "dumpfile name " + theDumpFile.getName());
                                                    Trace.trace(TRACE_MASKD, "dumpfile length " + theDumpFile.length());
                                                    Trace.trace(TRACE_MASKD, "the file is ready");
                                                    Calendar cal = DumpInfo.getDumpDate(theDumpFile);
                                                    Trace.trace(TRACE_MASKD, "the calendar is built");
                                                    PASystem theSystem = ((CommonProblem)currentProblem).getFailingSystem();
                                                    Trace.trace(TRACE_MASKD, "build the dump structure");
                                                    Trace.trace(TRACE_MASKD, "filename" + fileName);
                                                    Trace.trace(TRACE_MASKD, "problemNumber" + currentProblem.getProblemNumber());
                                                    Trace.trace(TRACE_MASKD, "length" + theDumpFile.length());
                                                    Trace.trace(TRACE_MASKD, "name" + theDumpFile.getName());
                                                    Trace.trace(TRACE_MASKD, "failing system" + theSystem);
                                                    Trace.trace(TRACE_MASKD, "cal" + cal);
                                                    String hostName = InetAddress.getLocalHost().getHostName();
                                                    PADump tempDump = new PADump(new String[]{pdd.getType()}, new String[]{hostName}, new Integer[]{new Integer(currentProblem.getProblemNumber())}, new Calendar[]{cal}, new String[]{Long.toString(theDumpFile.length())}, new String[]{theDumpFile.getName()}, new String[]{((CommonProblem)currentProblem).getFailingSystem().toString()});
                                                    paDumpList.add(tempDump);
                                                    if (++numberOfDumpsFound != numOfAvailableDumps) continue;
                                                    Trace.trace(TRACE_MASKD, "in the dataset iterator");
                                                    Trace.trace(TRACE_MASKD, "and reached the maximum nuber of dumps.  Break");
                                                    break;
                                                }
                                                Trace.trace(TRACE_MASKD, "didn't find the file in the list");
                                            }
                                            Trace.trace(TRACE_MASKD, "done with the data sets on problem" + currentProblem.getProblemNumber());
                                        }
                                        if (numberOfDumpsFound != numOfAvailableDumps) continue;
                                        Trace.trace(TRACE_MASKD, "end of problem iterator");
                                        Trace.trace(TRACE_MASKD, "got the maximum number of dumps.  Break");
                                        break block18;
                                    }
                                    break block18;
                                }
                                return new PADump();
                            }
                            return new PADump();
                        }
                        catch (Exception e) {
                            Trace.trace(TRACE_MASKD, "got exception");
                            Trace.trace(TRACE_MASKD, e);
                            return new PADump();
                        }
                    }
                    Trace.trace(TRACE_MASKF, "no files on the dump dir");
                } else {
                    return new PADump();
                }
            }
            Trace.trace(TRACE_MASKD, "all done now build the return data");
            int dumpListSize = paDumpList.size();
            if (dumpListSize != 0) {
                PADump returnDump = new PADump();
                Trace.trace(TRACE_MASKD, "build the return buffer");
                String[] typeArray = new String[dumpListSize];
                String[] hmcArray = new String[dumpListSize];
                Integer[] probNumArray = new Integer[dumpListSize];
                Calendar[] dateArray = new Calendar[dumpListSize];
                String[] nameArray = new String[dumpListSize];
                String[] sizeArray = new String[dumpListSize];
                String[] failSysArray = new String[dumpListSize];
                Iterator dumpIt = paDumpList.iterator();
                int j = 0;
                while (dumpIt.hasNext()) {
                    Trace.trace(TRACE_MASKD, "fill in the data. pass " + j);
                    PADump element = (PADump)dumpIt.next();
                    typeArray[j] = element.getDumpType()[0];
                    hmcArray[j] = element.getHMCContainingDump()[0];
                    probNumArray[j] = element.getProblemNumber()[0];
                    dateArray[j] = element.getDumpDate()[0];
                    nameArray[j] = element.getDumpName()[0];
                    sizeArray[j] = element.getRawDumpSize()[0];
                    failSysArray[j] = element.getOwningSystem()[0];
                    ++j;
                }
                returnDump = new PADump(typeArray, hmcArray, probNumArray, dateArray, sizeArray, nameArray, failSysArray);
                return returnDump;
            }
            return new PADump();
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKD, "got an exception");
            Trace.trace(TRACE_MASKD, e);
            return new PADump();
        }
    }

    public static Calendar getDumpDate(File theDump) {
        Calendar theCal = Calendar.getInstance();
        if (theDump != null) {
            theCal.setTime(new Date(theDump.lastModified()));
        }
        try {
            FileInputStream fis = new FileInputStream(theDump);
            byte[] data = new byte[150];
            int bytesRead = fis.read(data, 0, 64);
            Trace.trace(TRACE_MASKD, "the data is:");
            Trace.trace(TRACE_MASKD, data);
            int fileDirectory = ByteArray.extractU16(data, 8, false);
            Trace.trace(TRACE_MASKD, "the end if the file directory is at " + fileDirectory);
            int fileOffest = fileDirectory;
            bytesRead = fis.read(data, 0, 32);
            Trace.trace(TRACE_MASKD, "read in the first section:");
            Trace.trace(TRACE_MASKD, "the data is:");
            Trace.trace(TRACE_MASKD, data);
            boolean atEndOfDirectory = false;
            while (!atEndOfDirectory) {
                int directoryLength = ByteArray.extractU16(data, 8, false);
                Trace.trace(TRACE_MASKD, "the directory entry length is " + directoryLength);
                long lastSectionFlag = ByteArray.extractU32(data, 16, false);
                Trace.trace(TRACE_MASKD, "last section data is " + lastSectionFlag);
                if ((lastSectionFlag & 1L) > 0L) {
                    atEndOfDirectory = true;
                    Trace.trace(TRACE_MASKD, "last section is true");
                } else {
                    Trace.trace(TRACE_MASKD, "last section is false");
                }
                int bytesToRead = directoryLength - 32;
                Trace.trace(TRACE_MASKD, "bytes to read are " + bytesToRead);
                int remainder = fis.read(data, 0, bytesToRead);
                Trace.trace(TRACE_MASKD, "the remainder data is:");
                Trace.trace(TRACE_MASKD, data);
                Trace.trace(TRACE_MASKD, "read the next header:");
                if (!atEndOfDirectory) {
                    fis.read(data, 0, 32);
                    Trace.trace(TRACE_MASKD, "the next header:");
                    Trace.trace(TRACE_MASKD, data);
                    continue;
                }
                Trace.trace(TRACE_MASKD, "at the end don't read the next chunk");
            }
            Trace.trace(TRACE_MASKD, "we are at the end of the directory entires");
            Trace.trace(TRACE_MASKD, "read the date out of the file");
            fis.read(data, 0, 16);
            Calendar cal = Calendar.getInstance();
            int year = DumpInfo.BCDValue(data[8]) * 100;
            year += DumpInfo.BCDValue(data[9]);
            int month = DumpInfo.BCDValue(data[10]) - 1;
            int day = DumpInfo.BCDValue(data[11]);
            int hour = DumpInfo.BCDValue(data[12]);
            int minute = DumpInfo.BCDValue(data[13]);
            int second = DumpInfo.BCDValue(data[14]);
            cal.set(year, month, day, hour, minute, second);
            Trace.trace(TRACE_MASKD, "the time is:" + cal.getTime());
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "got exeception reading the dump file");
            Trace.trace(TRACE_MASKF, e);
        }
        return theCal;
    }

    public static int BCDValue(byte data) {
        int value = 0;
        value += (data >> 4 & 0xF) * 10;
        return value += data & 0xF;
    }

    public static void main(String[] args) {
        Trace.trace(TRACE_MASKD, "test stub v1.2");
        File directory = new File("/dump");
        File[] fileList = directory.listFiles();
        int i = 0;
        while (i < fileList.length) {
            File dumpFile = fileList[i];
            Calendar cal = DumpInfo.getDumpDate(dumpFile);
            System.out.println("the dump time stamp for " + dumpFile + " is " + cal.getTime() + "\n");
            ++i;
        }
        if (fileList.length == 0) {
            System.out.println("no dumps to read");
        }
    }
}

